<?php


class ControllerExtensionPaymentLinkify extends Controller {

    
    public function confirm() {
        if($this->request->server["REQUEST_METHOD"] != "POST"){
            echo "Request type not allowed";
            return;
        }

        $this->language->load('extension/payment/linkify');
        $this->load->model('checkout/order');

        $order_id = $this->request->post["order_id"];
        $order_info = $this->model_checkout_order->getOrder($order_id);
        if(!$order_info){
            echo "Order not found";
            return;
        }

        //Change the order status to 'Pending'
        if($order_info["order_status_id"] == 0){
            $this->model_checkout_order->addOrderHistory(
                $order_id, 
                explode(',', $this->config->get('payment_linkify_pending_status_ids'))[0], 
                $this->language->get('order_history_confirmed_message')." <a target='_blank' href='".$this->getPaymentUrl($order_id)."'>".$this->getPaymentUrl($order_id)."</a>", 
                $this->config->get('payment_linkify_send_client_notification_on_pending') == "on"
            );
        }
        //Redirect to the payment URL
        $this->response->redirect($this->getPaymentUrl($order_id));
	    return;
    }

	public function index() {
		$this->language->load('extension/payment/linkify');
		$this->load->model('checkout/order');
        
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        
		if ($order_info) {
            $data['valid_currency'] = $order_info['currency_code'] == 'CLP';
            $data['invalid_currency_message'] = $this->language->get('invalid_currency_message');
            
            $data['button_confirm'] = $this->language->get('button_confirm');
            $data['pay_instructions'] = $this->language->get('pay_instructions');
            
            $data['action'] = $this->url->link('extension/payment/linkify/confirm', '', 'SSL');
            $data['order_id'] = $this->session->data['order_id'];
            return $this->load->view('extension/payment/linkify', $data);
        }
        
    }

    #Callback url used by Linkify APP

	public function callback() {

        $request_method = $this->request->server["REQUEST_METHOD"];
        $body = $request_method == "GET" ? $this->request->get : json_decode(file_get_contents('php://input'), true);
        unset($body["route"]);

        //Validate the request
        $linkify_confirmation_token = $this->request->server['HTTP_X_LINKIFY_CONFIRMATION'];
        $secret =  $this->config->get('payment_linkify_secret');

        $this->checkHmac($linkify_confirmation_token, json_encode($body, true) , $secret);

        //Load the order
        $this->load->model('checkout/order');
        $order_id = $body["id"];
        $order_info = $this->model_checkout_order->getOrder($order_id);

        if(!$order_info){
            $this->sendHttpResponse(['message' => "No se encontró la orden #$order_id"] , 422);
        }
        if($order_info['currency_code'] != "CLP"){
            $this->sendHttpResponse(['message' => "La orden no está en CLP"] , 422);
        }
        $order_total = $this->currency->format($order_info['total'], $order_info['currency_code'], false, false);

        //Handle cases for GET, POST and PUT
        if($request_method == "GET"){
            //Check if the order still pending for payment
            if(!in_array($order_info["order_status_id"], $this->getPendingPaymentStatuses())){
                $this->sendHttpResponse(['message' => "La orden #$order_id no está pendiente de pago"],422);
            }

            $paid_amount = $this->getOrderPaidAmount($order_id);

            //Get the order products detail
            $this->load->model('account/order');
            $products = $this->model_account_order->getOrderProducts($order_id); 
            $products_detail = ["<b>Orden #$order_id</b>"];
            foreach($products as $product){
                $products_detail[] = "{$product['name']} {$product['model']}". ($product['quantity'] == 1 ? "" :   " x {$product['quantity']}");
            }
            
            $description = implode("\n", $products_detail);

            // Return the payment info
            $this->sendHttpResponse(["amount" => ($order_total - $paid_amount), "description" => $description], 200);
        }elseif($request_method == "POST"){
            // Check that the order pending amount hasn't changed. 
            // This consider cases when this is not the first time the notification happens (previous failed when some transactions where already added to DB)
            $transfers_data = $body['transfers_data'];
            $unnotified_transfers = [];
            $notified_transfers_amount = 0;
            //Search for transfers in this notification that are already added to the DB
            foreach($transfers_data as $transfer){
                $oc_payments = $this->getOpenCartLinkedPayments($transfer["hashid"]);
                if($oc_payments->num_rows > 0){
                    // If is linked to this order, omit
                    if($oc_payments->rows[0]["opencart_order_id"] == $order_id){
                        $notified_transfers_amount += $transfer["amount"];
                        continue;
                    }
                    // If it is linked to another order, return error
                    else{
                        $this->sendHttpResponse([
                                "message" => "Error: La transferencia #{$transfer["hashid"]} está vinculada a otra orden", 
                                "completed" => false
                        ],200);
                    }
                }else{
                    $unnotified_transfers[] = $transfer;
                }
            }

            if($body['payment_amount'] - $notified_transfers_amount != ($order_total - $this->getOrderPaidAmount($order_id))){
                $this->sendHttpResponse([
                        "message" => "La orden #$order_id fue modificada por lo que no se pudo procesar el pago. Reinicie el proceso de validación para cargar la nueva información de la orden.", 
                        "completed" => false
                ],200);
            }

            if(sizeof($unnotified_transfers) > 0){
                // Check if the order still pending for payment
                if(!in_array($order_info["order_status_id"], $this->getPendingPaymentStatuses())){
                    $this->sendHttpResponse([
                        "message" => "La orden #$order_id no está pendiente de pago, probablemente porque expiró. Realice una nueva orden para vincular la transferencia.", 
                        "completed" => false
                    ],200);
                }
                foreach($unnotified_transfers as $unnotified_transfer){
                    $this->addTransferToDb($order_id, $unnotified_transfer["hashid"], $unnotified_transfer["amount"]);
                }
    
                $transfers_detail = [];
                foreach($unnotified_transfers as $transfer){
                    $transfers_detail[] = "".
                        "Nombre: {$transfer["name"]}\n".
                        "Banco: {$transfer["bank"]["name"]}\n".
                        "Monto: \${$transfer["amount"]} CLP\n".
                        "RUT: {$transfer["rut"]}\n".
                        "Fecha: {$transfer["date"]}\n".
                        "ID: {$transfer["hashid"]}\n".
                    "";
                }
                $s = sizeof($unnotified_transfers) > 1 ? "s" : "";
                $payment_link = $body['underpaid'] == true ? "Para pagar el restante ingrese a <a target='_blank' href='".$this->getPaymentUrl($order_id)."'>".$this->getPaymentUrl($order_id)."</a> \n" : "";
                $order_confirmation_message = "".
                    "\$" . $this->getTotalPaidFromTransfersData($unnotified_transfers) . " CLP pagados (validados por Linkify)\n".
                    "$payment_link\n".
                    implode("\n", $transfers_detail);

                $new_status = $body['underpaid'] == true ? $this->getNextPaymentStatusId($order_info["order_status_id"], "partial") : $this->getNextPaymentStatusId($order_info["order_status_id"], "completed");
                $send_mail = $body['underpaid'] == true ? $this->config->get('payment_linkify_send_client_notification_on_partial') == "on" : $this->config->get('payment_linkify_send_client_notification_on_completed') == "on";
                $this->model_checkout_order->addOrderHistory($order_id, $new_status, $order_confirmation_message, $send_mail); 
            }

            if ($body["underpaid"]){
                $checkout_message = 'Pago parcial procesado correctamente. Aun quedan $'.($order_total - $this->getOrderPaidAmount($order_id)). ' por pagar. Reinicie el proceso para pagar el restante';
                $this->sendHttpResponse(['message' => $checkout_message, 'restart' => true], 200);
            }else{
                $this->sendHttpResponse(['message' => 'Pago procesado correctamente.', 'redirect' => $this->url->link('checkout/success')],200);
            }
        }elseif($request_method == "DELETE"){

            //Check if the current status is available for refund (is in any config lane). The getNextPaymentStatusId throws an exception when the status is not found
            $this->getNextPaymentStatusId($order_info["order_status_id"], "pending");

            // If any transfer is not linked to an order, return error
            $transfers_data = $body['transfers_data'];
            foreach($transfers_data as $transfer){
                $oc_payments = $this->getOpenCartLinkedPayments($transfer["hashid"]);
                if($oc_payments->num_rows > 0){
                    // If is linked to this order, omit
                    if($oc_payments->rows[0]["opencart_order_id"] == $order_id){
                        continue;
                    }
                    //If linked to other order, error
                    else{
                        $this->sendHttpResponse([
                                "message" => "Error: Transferencia #{$transfer["hashid"]} está vinculada a otra orden", 
                                "should_send_mail" => false
                        ],400);
                    }
                }
                //If not linked to any order, error
                else{
                    $this->sendHttpResponse([
                            "message" => "Error: Transferencia #{$transfer["hashid"]} no está vinculada a la orden", 
                            "should_send_mail" => false
                    ],400);
                }
            }

            $transfers_ids = [];
            foreach($transfers_data as $transfer){
                $this->unlinkTransferFromOrder($order_id, $transfer["hashid"]);
                $transfers_ids[] = $transfer["hashid"];
            }
            $new_status = $this->getOrderPaidAmount($order_id) > 0 ? $this->getNextPaymentStatusId($order_info["order_status_id"], "partial") : $this->getNextPaymentStatusId($order_info["order_status_id"], "pending") ;
            $s = sizeof($transfers_ids) > 1 ? "s" : "";
            $checkout_message = "Transferencia$s ".implode(", ", $transfers_ids)." desvinculada$s de la orden #$order_id";
            $this->model_checkout_order->addOrderHistory($order_id, $new_status, $checkout_message, false); 
            $this->sendHttpResponse(['message' => $checkout_message],200);

        }else{
            $this->sendHttpResponse(['message' => "Unsopported request method"],400);
        }
    }
    
    #Helper functions

    //Exit with response
    private function sendHttpResponse($response, $status_code){
        header('HTTP/1.1 ' . $status_code . ' OK');
        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    //Check if a request is from linkify
    private function checkHmac($incoming_hmac, $json_encoded_body, $secret_key){
        $computed_hmac = hash_hmac('sha256',$json_encoded_body,$secret_key, false);
        if($computed_hmac != $incoming_hmac){
            $this->sendHttpResponse(['message' => "Hubo un error de autenticación al conectarse con la tienda", 'should_send_email' => true],401);
        }
    }

    //Compute total amount paid from a list with one or more transfers.
    private function getTotalPaidFromTransfersData($transfers_data){
        $total_amount_paid = 0;
        foreach($transfers_data as $transfer){
            $total_amount_paid = $total_amount_paid + intval($transfer['amount']);
        }
        return $total_amount_paid;
    }

    private function getPaymentUrl($order_id){
        $merchant_id = $this->config->get('payment_linkify_merchantid');
        return "https://app.linkify.cl/pay/$merchant_id/new/remote/$order_id";
    }

    private function getPendingPaymentStatuses(){
        return array_merge(explode(',', $this->config->get('payment_linkify_pending_status_ids')), explode(',', $this->config->get('payment_linkify_partial_status_ids')));
    }

    private function getNextPaymentStatusId($status_id_from, $status_name_to){
        $logic_lanes = array(
            "pending" => explode(',', $this->config->get('payment_linkify_pending_status_ids')),
            "partial" => explode(',', $this->config->get('payment_linkify_partial_status_ids')),
            "completed" => explode(',', $this->config->get('payment_linkify_completed_status_ids')),
        );

        $lane = -1;
        foreach(array_keys($logic_lanes) as $status_name){
            for($i = 0; $i < sizeof($logic_lanes[$status_name]); $i++){
                if($logic_lanes[$status_name][$i] == $status_id_from){
                    $lane = $i;
                    break;
                }
            }
            if($lane != -1){
                break;
            }
        }
        if($lane == -1){
            $this->sendHttpResponse(['message' => "El estado de la orden no es parte de ninguna regla de negocio configurada"],400);
        }

        return $logic_lanes[$status_name_to][$lane];
    }

    #Database functions

    private function getOrderPaidAmount($order_id){
        $transactions_summary = $this->db->query('SELECT SUM(amount) as amount FROM ' . DB_PREFIX . 'linkify_transfers WHERE opencart_order_id = ' . $this->db->escape($order_id) . ' AND linked = 1');
        return intval($transactions_summary->rows[0]["amount"]);
    }

    private function addTransferToDB($order_id, $linkify_transfer_hashid, $amount){
        $this->db->query('INSERT INTO ' . DB_PREFIX . 'linkify_transfers (linked, opencart_order_id, linkify_transfer_hashid, amount, creation_date, last_update_date) VALUES (1, ' . $this->db->escape($order_id) . ', \'' . $this->db->escape($linkify_transfer_hashid) . '\', ' . $this->db->escape($amount) . ', NOW(), NOW())');
    }

    private function unlinkTransferFromOrder($order_id, $linkify_transfer_hashid){
        $this->db->query('UPDATE ' . DB_PREFIX . 'linkify_transfers SET linked = NULL, last_update_date = NOW() WHERE opencart_order_id = ' . $this->db->escape($order_id) . ' AND linkify_transfer_hashid = \'' . $this->db->escape($linkify_transfer_hashid) . '\'');
    }

    private function getOpenCartLinkedPayments($linkify_transfer_hashid){
        return $this->db->query('SELECT * FROM ' . DB_PREFIX . 'linkify_transfers WHERE linkify_transfer_hashid = \'' . $this->db->escape($linkify_transfer_hashid) . '\' AND linked = 1');
    }

}

?>
