<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see https://developers.whmcs.com/payment-gateways/meta-data-params/
 *
 * @return array
 */
function linkify_MetaData()
{
    return array(
        'DisplayName' => 'Linkify',
        'APIVersion' => '1.1', // Use API Version 1.1
        'DisableLocalCreditCardInput' => true,
        'TokenisedStorage' => false,
    );
}

/**
 * Define gateway configuration options.
 *
 * The fields you define here determine the configuration options that are
 * presented to administrator users when activating and configuring your
 * payment gateway module for use.
 *
 * Supported field types include:
 * * text
 * * password
 * * yesno
 * * dropdown
 * * radio
 * * textarea
 *
 * Examples of each field type and their possible configuration parameters are
 * provided in the sample function below.
 *
 * @return array
 */
function linkify_config()
{
    return array(
        // the friendly display name for a payment gateway should be
        // defined here for backwards compatibility
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Linkify',
        ),
        'account_id' => array(
            'FriendlyName' => 'ID de cuenta',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Ingrese su ID de cuenta de Linkify',
        ),
        'secret_key' => array(
            'FriendlyName' => 'Clave privada',
            'Type' => 'password',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Ingrese su clave privada de Linkify',
        ),
        'redirect' => array(
          'FriendlyName' => 'Redirección post-pago',
          'Type' => 'text',
          'Size' => '25',
          'Default' => '',
          'Description' => 'URL a redirigir despúes de ingresar un pago. Puede usar la variable <code>%INVOICE_ID%</code> (opcional)',
        ),
    );
}

/**
 * Payment link.
 *
 * Required by third party payment gateway modules only.
 *
 * Defines the HTML output displayed on an invoice. Typically consists of an
 * HTML form that will take the user to the payment gateway endpoint.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see https://developers.whmcs.com/payment-gateways/third-party-gateway/
 *
 * @return string
 */
function linkify_link($params)
{
    // Gateway Configuration Parameters
    $account_id = $params['account_id'];

    $invoice_id = $params['invoiceid'];

    $url = (getenv('LINKIFY_URL') ?: "https://app.linkify.cl") . "/pay/$account_id/new/remote/$invoice_id";
    $lang_pay_now = $params['langpaynow'];

    $logo = 'data:image/png;base64,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';
    
    $htmlOutput = "<img style='height: 90px;' src='$logo'/><br/>";
    $htmlOutput .= "<a style='margin-top: 1em;' class='btn btn-primary' href='$url' role='button'>$lang_pay_now</a>";

    return $htmlOutput;
}

/**
 * Refund transaction.
 *
 * Called when a refund is requested for a previously successful transaction.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see https://developers.whmcs.com/payment-gateways/refunds/
 *
 * @return array Transaction response status
 */
function linkify_refund($params)
{
    return array(
        'status' => 'success',
        'rawdata' => 'Linkify no maneja los reembolsos, la transferencia debe realizarse manualmente',
        'transid' => "refund-$params[transid]",
    );
}

/**
 * Cancel subscription.
 *
 * If the payment gateway creates subscriptions and stores the subscription
 * ID in tblhosting.subscriptionid, this function is called upon cancellation
 * or request by an admin user.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see https://developers.whmcs.com/payment-gateways/subscription-management/
 *
 * @return array Transaction response status
 */
function linkify_cancelSubscription($params)
{
    return array(
        'status' => 'success',
        'rawdata' => 'Linkify no maneja suscripciones',
    );
}
